/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.google.common.collect.ImmutableList;
import com.ninni.spawn.entity.Ant;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AntModel<E extends Ant>
extends AgeableListModel<E> {
    public static final String ABDOMEN = "abdomen";
    public static final String LEFT_ANTENNA = "left_antenna";
    public static final String RIGHT_ANTENNA = "right_antenna";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftAntenna;
    private final ModelPart rightAntenna;
    private final ModelPart abdomen;
    private final ModelPart leftForeLeg;
    private final ModelPart rightForeLeg;
    private final ModelPart leftMidLeg;
    private final ModelPart rightMidLeg;
    private final ModelPart leftBackLeg;
    private final ModelPart rightBackLeg;

    public AntModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.leftForeLeg = this.root.m_171324_("left_front_leg");
        this.leftMidLeg = this.root.m_171324_("left_mid_leg");
        this.leftBackLeg = this.root.m_171324_("left_hind_leg");
        this.rightForeLeg = this.root.m_171324_("right_front_leg");
        this.rightMidLeg = this.root.m_171324_("right_mid_leg");
        this.rightBackLeg = this.root.m_171324_("right_hind_leg");
        this.head = this.body.m_171324_("head");
        this.abdomen = this.body.m_171324_(ABDOMEN);
        this.leftAntenna = this.head.m_171324_(LEFT_ANTENNA);
        this.rightAntenna = this.head.m_171324_(RIGHT_ANTENNA);
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(14, 13).m_171481_(-1.5f, -1.0f, -2.5f, 3.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)0.5f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-2.5f, -3.0f, -3.0f, 5.0f, 4.0f, 4.0f).m_171514_(15, 0).m_171481_(-1.5f, 0.0f, -4.0f, 3.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.5f));
        PartDefinition leftAntenna = head.m_171599_(LEFT_ANTENNA, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(0.0f, -4.0f, -3.5f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)1.0f, (float)-3.0f, (float)-1.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rightAntenna = head.m_171599_(RIGHT_ANTENNA, CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(0.0f, -4.0f, -3.5f, 0.0f, 4.0f, 4.0f), PartPose.m_171423_((float)-1.0f, (float)-3.0f, (float)-1.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition abdomen = body.m_171599_(ABDOMEN, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -3.0f, -1.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)1.5f));
        PartDefinition leftForeLeg = partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171481_(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.5f, (float)-1.0f, (float)0.0f, (float)0.3927f, (float)0.7854f));
        PartDefinition rightForeLeg = partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171480_().m_171481_(-4.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)21.5f, (float)-1.0f, (float)0.0f, (float)-0.3927f, (float)-0.7854f));
        PartDefinition leftMidLeg = partdefinition.m_171599_("left_mid_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171481_(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition rightMidLeg = partdefinition.m_171599_("right_mid_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171480_().m_171481_(-4.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leftBackLeg = partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171481_(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)21.5f, (float)1.0f, (float)0.0f, (float)-0.3927f, (float)0.7854f));
        PartDefinition rightBackLeg = partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(-1, 22).m_171480_().m_171481_(-4.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)21.5f, (float)1.0f, (float)0.0f, (float)0.3927f, (float)-0.7854f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        limbDistance = Mth.m_14036_((float)limbDistance, (float)-0.45f, (float)0.45f);
        float speed = 0.5f;
        float degree = 1.5f;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.leftAntenna.f_104205_ = Mth.m_14031_((float)(animationProgress * speed * 0.1f)) * degree * 0.4f * 0.25f;
        this.leftAntenna.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.05f)) * degree * 0.75f * 0.25f;
        this.rightAntenna.f_104205_ = Mth.m_14031_((float)(animationProgress * speed * 0.1f + (float)Math.PI)) * degree * 0.4f * 0.25f;
        this.rightAntenna.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.05f + (float)Math.PI)) * degree * 0.75f * 0.25f;
        this.abdomen.f_104205_ = Mth.m_14031_((float)(limbAngle * speed * 0.3f)) * degree * 0.2f * limbDistance;
        this.leftForeLeg.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f)) * degree * 0.25f * limbDistance + 0.7854f;
        this.leftForeLeg.f_104204_ = Mth.m_14031_((float)(limbAngle * speed * 1.8f)) * degree * 1.0f * limbDistance + 0.3927f;
        this.rightForeLeg.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f)) * degree * 0.25f * limbDistance - 0.7854f;
        this.rightForeLeg.f_104204_ = Mth.m_14031_((float)(limbAngle * speed * 1.8f)) * degree * 1.0f * limbDistance - 0.3927f;
        this.leftMidLeg.f_104205_ = Mth.m_14031_((float)(limbAngle * speed * 1.8f)) * degree * 0.25f * limbDistance + 0.7854f;
        this.leftMidLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f)) * degree * 1.0f * limbDistance;
        this.rightMidLeg.f_104205_ = Mth.m_14031_((float)(limbAngle * speed * 1.8f)) * degree * 0.25f * limbDistance - 0.7854f;
        this.rightMidLeg.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f)) * degree * 1.0f * limbDistance;
        this.leftBackLeg.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f + (float)Math.PI)) * degree * 0.25f * limbDistance + 0.7854f;
        this.leftBackLeg.f_104204_ = Mth.m_14031_((float)(limbAngle * speed * 1.8f + (float)Math.PI)) * degree * 1.0f * limbDistance - 0.3927f;
        this.rightBackLeg.f_104205_ = Mth.m_14089_((float)(limbAngle * speed * 1.8f + (float)Math.PI)) * degree * 0.25f * limbDistance - 0.7854f;
        this.rightBackLeg.f_104204_ = Mth.m_14031_((float)(animationProgress * speed * 1.8f + (float)Math.PI)) * degree * 1.0f * limbDistance + 0.3927f;
        if (entity.m_21825_()) {
            this.body.f_104201_ = 22.5f;
            this.leftForeLeg.f_104201_ = 23.5f;
            this.leftMidLeg.f_104201_ = 23.5f;
            this.leftBackLeg.f_104201_ = 23.5f;
            this.rightForeLeg.f_104201_ = 23.5f;
            this.rightMidLeg.f_104201_ = 23.5f;
            this.rightBackLeg.f_104201_ = 23.5f;
            this.leftForeLeg.f_104205_ = 0.0f;
            this.leftMidLeg.f_104205_ = 0.0f;
            this.leftBackLeg.f_104205_ = 0.0f;
            this.rightForeLeg.f_104205_ = 0.0f;
            this.rightMidLeg.f_104205_ = 0.0f;
            this.rightBackLeg.f_104205_ = 0.0f;
        } else {
            this.body.f_104201_ = 20.5f;
            this.leftForeLeg.f_104201_ = 21.5f;
            this.leftMidLeg.f_104201_ = 21.5f;
            this.leftBackLeg.f_104201_ = 21.5f;
            this.rightForeLeg.f_104201_ = 21.5f;
            this.rightMidLeg.f_104201_ = 21.5f;
            this.rightBackLeg.f_104201_ = 21.5f;
            this.leftForeLeg.f_104205_ = 0.7854f;
            this.leftMidLeg.f_104205_ = 0.7854f;
            this.leftBackLeg.f_104205_ = 0.7854f;
            this.rightForeLeg.f_104205_ = -0.7854f;
            this.rightMidLeg.f_104205_ = -0.7854f;
            this.rightBackLeg.f_104205_ = -0.7854f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.root);
    }
}

